"""
    Implements the argparser file, including default configs that are used for the process right now.
    If any new experiment is created, these values will be flushed to a json,
    which will be included in the experiment folder
"""

import argparse
import tensorflow as tf
import torch

model_parser = argparse.ArgumentParser(description='Experiment Configuration Parser')
model_parser.add_argument('--random_seed', default=101, type=int,
                          help='an integer which determines the random seed. if no seed shall be provided, set this to 0')
model_parser.add_argument('--dtype', default='tf.float32', help='the floating point type that is going to be used globally')

model_parser.add_argument('--max_samples', default=512, type=int,
                          help='the number of sentences to sample for BERT embeddings')
model_parser.add_argument('--cuda', default='False',
                          help='Whether or not CUDA will be used. This argument will be ignored if CUDA is available')

model_parser.add_argument('--verbose', default=0, type=int, help='verbosity level. higher means more verbose')
model_parser.add_argument('--stemsearch', default=0, type=int, help='whether or not to stem the sentences to look for')

model_parser.add_argument('--dimred', default="none", help='which dimensionality reduction algorithm to use. If none specified, falling back to PCA. One of "nmf", "pca", "umap", "lda" ')
model_parser.add_argument('--dimred_dimensions', default=768, help='which dimensionality to reduce to during the dimred phase. Falling back to 4 if not specified')
model_parser.add_argument('--pca_whiten', default=False, help='which dimensionality to reduce to during the dimred phase. Falling back to 4 if not specified')
model_parser.add_argument('--normalization_norm', default="", help='What norm to normalize the vectors by before applying clustering. set to an invalid value if you dont want any normalization')
model_parser.add_argument('--standardize', default=False, help='What norm to normalize the vectors by before applying clustering. set to an invalid value if you dont want any normalization')

model_parser.add_argument(
    "--output_meaning_dir",
    default="./savedir/cluster_model_caches",
    type=str,
    required=False,
    help="The output directory where the meaning-cluster model trains and caches the cluster-models for each word individually.",
)

model_parser.add_argument("--seed", type=int, default=42, help="random seed for initialization")
